﻿# Der Windows Papst https://www.der-windows-papst.de
# Lese Dateien aus diesem Ordner die weg sortiert werden sollen
$files = Get-ChildItem 'D:\DATA\DESKTOP\__Loses_Zeug' -Recurse | where {!$_.PsIsContainer}
 
# Dateien die später neu einsortiert werden und zwar nach Jahren
$files
 
# Zielpfad der neu sortierten Dateien
$targetPath = 'M:\Sort Files'
 
foreach ($file in $files)
{

# Lese Jahr der Dateien aus
$year = $file.LastWriteTime.Year.ToString()
 
# Dateiausgabe
$file.Name
$year
 
# Ziel setzen
$Directory = $targetPath + "\" + $year + ""
# Ziel erstellen falls es nicht existiert
if (!(Test-Path $Directory))
{
New-Item $directory -type directory
}
 
# Dateien verschieben ; bitte den befehl manuell auf Move setzen anstatt Copy
$file | Copy-Item -Destination $Directory
}